/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.vanilla;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.api.model.ModelBakingContext;
import com.supermartijn642.fusion.api.model.ModelInstance;
import com.supermartijn642.fusion.api.model.ModelType;
import com.supermartijn642.fusion.api.model.SpriteIdentifier;
import com.supermartijn642.fusion.model.types.vanilla.VanillaModelSerializer;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_2960;
import net.minecraft.class_793;
import org.jetbrains.annotations.Nullable;

public class VanillaModelType
implements ModelType<class_793> {
    @Override
    public Collection<class_2960> getModelDependencies(class_793 data) {
        return data.method_4755();
    }

    @Override
    public class_1087 bake(ModelBakingContext context, class_793 data) {
        VanillaModelType.resolveParents(context, data);
        return data.method_4753(context.getModelBaker(), material -> context.getTexture(SpriteIdentifier.of(material)), context.getTransformation());
    }

    @Override
    @Nullable
    public class_793 getAsVanillaModel(class_793 data) {
        return data;
    }

    @Override
    public class_793 deserialize(JsonObject json) throws JsonParseException {
        return (class_793)class_793.field_4254.fromJson((JsonElement)json, class_793.class);
    }

    @Override
    public JsonObject serialize(class_793 value) {
        return (JsonObject)VanillaModelSerializer.GSON.toJsonTree((Object)value);
    }

    private static void resolveParents(ModelBakingContext context, class_793 model) {
        LinkedHashSet<class_793> passedModels = new LinkedHashSet<class_793>();
        while (model.field_4247 != null && model.field_4253 == null) {
            passedModels.add(model);
            ModelInstance<?> modelInstance = context.getModel(model.field_4247);
            if (modelInstance == null) {
                return;
            }
            class_793 parent = modelInstance.getAsVanillaModel();
            if (parent == null) {
                class_793.field_4248.warn("Vanilla model {} cannot have parent with model type {} for {}!", new Object[]{model, modelInstance.getModelType(), model.field_4247});
            }
            if (passedModels.contains(parent)) {
                class_793.field_4248.warn("Found 'parent' loop while loading model '{}' in chain: {} -> {}", new Object[]{model, passedModels.stream().map(Object::toString).collect(Collectors.joining(" -> ")), model.field_4247});
                parent = null;
            }
            if (parent == null) {
                model.field_4247 = class_1088.field_5374;
                parent = context.getModel(model.field_4247).getAsVanillaModel();
                if (parent == null) {
                    throw new RuntimeException("Got null for missing model request!");
                }
            }
            model.field_4253 = parent;
            model = parent;
        }
    }
}

